/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.itemblock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.blocks.metal.BlockMetalLamp;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandlerComplex;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockMetalLamp
extends ItemBlockTFC
implements IMetalItem {
    private static final Map<Metal, ItemBlockMetalLamp> TABLE = new HashMap<Metal, ItemBlockMetalLamp>();
    public static int CAPACITY;

    public static Set<Fluid> getValidFluids() {
        String[] fluidNames = ConfigTFC.Devices.LAMP.fuels;
        HashSet<Fluid> validFluids = new HashSet<Fluid>();
        for (String fluidName : fluidNames) {
            validFluids.add(FluidRegistry.getFluid((String)fluidName));
        }
        return validFluids;
    }

    public static Item get(Metal metal) {
        return (Item)TABLE.get((Object)metal);
    }

    public ItemBlockMetalLamp(Metal metal) {
        super(BlockMetalLamp.get(metal));
        CAPACITY = ConfigTFC.Devices.LAMP.tank;
        if (!TABLE.containsKey((Object)metal)) {
            TABLE.put(metal, this);
        }
        CapabilityItemHeat.CUSTOM_ITEMS.put(IIngredient.of((Item)this), () -> new ItemHeatHandler(null, metal.getSpecificHeat(), metal.getMeltTemp()));
        OreDictionaryHelper.register((Item)this, "lamp");
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        IFluidHandler lampCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (lampCap != null) {
            return lampCap.drain(CAPACITY, false) == null;
        }
        return true;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack;
        IFluidHandler fluidCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidCap != null && (fluidStack = fluidCap.drain(CAPACITY, false)) != null) {
            String fluidName = fluidStack.getLocalizedName();
            return new TextComponentTranslation(this.func_77658_a() + ".filled.name", new Object[]{fluidName}).func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidWhitelistHandlerComplex(stack, CAPACITY, ItemBlockMetalLamp.getValidFluids());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (Fluid fluid : ItemBlockMetalLamp.getValidFluids()) {
                ItemStack stack = new ItemStack((Item)this);
                IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (cap != null) {
                    cap.fill(new FluidStack(fluid, CAPACITY), true);
                }
                items.add((Object)stack);
            }
        }
    }

    @Override
    @Nullable
    public Metal getMetal(ItemStack stack) {
        return ((BlockMetalLamp)this.field_150939_a).getMetal();
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        return 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMetalInfo(ItemStack stack, List<String> text) {
        Metal metal;
        FluidStack fluidStack;
        IFluidHandler fluidCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        boolean spacer = false;
        if (fluidCap != null && (fluidStack = fluidCap.drain(CAPACITY, false)) != null) {
            spacer = true;
            text.add("");
            String fluidName = fluidStack.getLocalizedName();
            text.add(I18n.func_135052_a((String)"tfc.tooltip.barrel_fluid", (Object[])new Object[]{fluidStack.amount, fluidName}));
        }
        if ((metal = this.getMetal(stack)) != null) {
            if (!spacer) {
                text.add("");
            }
            text.add(I18n.func_135052_a((String)"tfc.tooltip.metal", (Object[])new Object[]{I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0])}));
            text.add(I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{this.getSmeltAmount(stack)}));
            text.add(I18n.func_135052_a((String)Helpers.getEnumName(metal.getTier()), (Object[])new Object[0]));
        }
    }
}

